Accompanying source to the paper presenting the surface node placing algorithm.
The repository contains 6 files:

- `README.md`: this file containing usage instructions
- `PA.hpp`: header file with the implementation of the algorithm
- `nanoflann.hpp`: header file with implementation of the k-d tree structure, copied
from nanoflann repository
- `example.cpp`: source file that showcases basic algorithm usage
- `plot_example_2d.m`: a Matlab/Octave source file that plots 2D domains
- `plot_example_2d.m`: a Matlab/Octave source file that plots 3D domains

To compile the example, a C++11 compliant compiler must be present in your system,
and the Eigen matrix library must be installed and discoverable to the compiler.
The Eigen matrix library can be obtained from http://eigen.tuxfamily.org/.

To compile the test case run
```
g++ -o example example.cpp -std=c++11 -O3 -Wall -DNDEBUG
```

The compilation should succeed without errors or warnings. Then run
```
./example
```
which will fill a polar curve in 2D and a heart-like surface in 3D, both
mentioned in the paper. The generated nodes are saved in `example_2d.txt` and
`example_3d.txt`. The accompanying scripts `plot_example_2d.m` and `plot_example_3d.m`
can be used to plot the generated nodes.

Urban Duh, urban.duh@student.fmf.uni-lj.si
Gregor Kosec, gregor.kosec@ijs.si
Jure Slak, jure.slak@ijs.si
